package tomek.it.graphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*		Structure:  
 		JFrame  (BorderLayout)	f
 		 +---->  JPanel (FlowLayout) [BorderLayout.CENTER]		cards
 		 | 		  +---->  JPanel (FlowLayout)		jp1
 		 | 		  +---->  JPanel (FlowLayout)		jp2
 		 | 		  +---->  JPanel (FlowLayout)		jp3
 		 +---->  JPanel (FlowLayout) [BorderLayout.SOUTH]		control
 		  		  +---->  JButton		b1
		  		  +---->  JButton		b2
*/

public class CardPanel00b {

    private final static Random random = new Random();
    
    private final static int defaultWidth = 320;
    private final static int defaultHeight = 240;
    
    private static void createAndShowGUI() {
 
    	JFrame f = new JFrame("CardLayout DEMO");
    	
    	final String previous = "<< Prev";
    	final String next = "Next >>";
    	
        JPanel cards = new JPanel();
        JPanel control = new JPanel();
        
    	ActionListener myActionListener = new ActionListener() {
    		public void actionPerformed(ActionEvent e) {
    			System.out.println(cards.getLayout()+" | "+e);
    		}
    	};
     
        JButton b1 = new JButton(previous);
        b1.addActionListener(myActionListener);
        
        JButton b2 = new JButton(next);
        b2.addActionListener(myActionListener);

        control.add(b1);
        control.add(b2);
        

		MouseListener myMouseListener = new MouseListener() {

			public void mouseClicked(MouseEvent e) {}

			public synchronized void mousePressed(MouseEvent e) {
				System.out.println(e);
				((JPanel)e.getSource()).setBackground(new Color(random.nextInt()));
			}

			public void mouseReleased(MouseEvent e) {}

			public void mouseEntered(MouseEvent e) {}

			public void mouseExited(MouseEvent e) {}

		};
        
        JPanel jp1 = new JPanel();
        jp1.addMouseListener(myMouseListener);
        jp1.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
        jp1.setBackground(new Color(random.nextInt()));
        jp1.add(new JLabel("First"));
        
        JPanel jp2 = new JPanel();
        jp2.addMouseListener(myMouseListener);
        jp2.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
        jp2.setBackground(new Color(random.nextInt()));
        jp2.add(new JLabel("Second"));
 
        JPanel jp3 = new JPanel();
        jp3.addMouseListener(myMouseListener);
        jp3.setPreferredSize(new Dimension(defaultWidth, defaultHeight));
        jp3.setBackground(new Color(random.nextInt()));
        jp3.add(new JLabel("Third"));
         
        cards.add(jp1);
        cards.add(jp2);
        cards.add(jp3);
        
        f.add(cards, BorderLayout.CENTER);
        f.add(control, BorderLayout.SOUTH);
        
        f.pack();
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setVisible(true);
    }
        
    public static void main(String[] args) {
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() { createAndShowGUI(); }
        });        
    }
    
}
